#####
source("functions.R")

library(KMsurv); data(std)
w<-std$time; x<-w; n<-length(w)

######################
##### Table 4 ########
######################
round(AnalisisDescriptivo(w),1)

aux.REPM<-EMV.REPM(w, psi.ini=c(1,1,1))
beta.REPM<-aux.REPM$beta.estimado; mu.REPM<-aux.REPM$mu.estimado; gamma.REPM<-aux.REPM$gamma.estimado
psi.REPM<-mu.REPM^(beta.REPM)

aux.gamma<-EMV.Gamma(w, psi.ini.gamma=c(2,1)) 
alpha.gamma<-aux.gamma$psi[1]; beta.gamma<-aux.gamma$psi[2]

aux.PM<-EMV.PM(w, psi.ini.PM=c(2,1)) 
alpha.PM<-aux.PM$psi[1]; beta.PM<-aux.PM$psi[2]

aux.M<-EMV.M(w, ini=1) 
alpha.M<-aux.M$psi


aa1<-c(aux.M$psi, NaN, NaN, NaN, aux.M$L, aux.M$Criteria)
aa2<-c(aux.M$sd, NaN, NaN, NaN, NaN, NaN)
aa3<-c(aux.PM$psi, NaN, NaN, aux.PM$L, aux.PM$Criteria)
aa4<-c(aux.PM$sd, NaN, NaN, NaN, NaN)
aa5<-c(aux.gamma$psi, NaN, NaN, aux.gamma$L, aux.gamma$Criteria)
aa6<-c(aux.gamma$sd, NaN, NaN, NaN, NaN)
aa7<-c(NaN, aux.REPM$beta.estimado, aux.REPM$mu.estimado, aux.REPM$gamma.estimado, aux.REPM$loglike, aux.REPM$Criteria)
aa8<-c(NaN, aux.REPM$sd, NaN, NaN)

######################
##### Table 5 ########
######################
aa<-round(cbind(aa1,aa2,aa3,aa4,aa5,aa6,aa7,aa8),3)
colnames(aa)<-c("M.est","M.se","PM.est","PM.se","g.est","g.se","REPM.est","REPM.se")
rownames(aa)<-c("alpha","beta","mu","gamma","loglike","AIC")
aa




####################
## 	Figure 2 	##
####################

##Figure 2a
hist(w,freq=F,main="", ylab="density", xlab="time", col=NULL,breaks=10,
cex.lab=1.6, cex.axis=1.6)
curve.REPM(mu.REPM,beta.REPM,gamma.REPM,add=T,lwd=3)
curve( (4/sqrt(pi))*alpha.PM^(3/2)*beta.PM*x^(3*beta.PM-1)*exp(-alpha.PM*x^(2*beta.PM)),lwd=3,
lty=2,add=T )

beta<-1
curve( (4/sqrt(pi))*alpha.M^(3/2)*beta*x^(3*beta-1)*exp(-alpha.M*x^(2*beta)),lwd=3,
lty=3,add=T )

curve(dgamma(x,alpha.gamma,beta.gamma), lwd=3, lty=4, add=T)
a<-c("REPM","PM","M", "G")
legend("topright",a,lty=c(1,2,3,4),bty="n", cex=1.5, lwd=3)


##Figure 2b
plot(ecdf(w),ylab="cumulative distribution function",
xlab="time",main="",cex.lab=1.6, cex.axis=1.6, xlim=c(0,2000))

curve(pgamma(x^(2*beta.REPM)/(2*mu.REPM^(2*beta.REPM)), 3/2, 1)^gamma.REPM,
	lwd=3,add=T,xlim=c(0,2000))

curve( pgamma(alpha.PM*x^(2*beta.PM),3/2,1),add=T,lwd=3,lty=2, xlim=c(0,2000) )

curve( pgamma(alpha.M*x^(2*beta),3/2,1),add=T,lwd=3,lty=3,xlim=c(0,2000) )

curve( pgamma(x,alpha.gamma,beta.gamma),add=T,lwd=3,lty=4,xlim=c(0,2000) )
a<-c("REPM","PM","M", "G")
legend("right",a,lty=c(1,2,3,4),bty="n", cex=1.5, lwd=3)



####################
##	Figure 3	##
####################

set.seed(2021)

##Figure 3a
theta<-c(mu.REPM,beta.REPM,gamma.REPM)
QQ_REPM(w,theta,xlim=c(0,2000),ylim=c(0,2000))

##Figure 3b
theta<-c(alpha.PM, beta.PM)
QQ_PM(w,theta,M=F, xlim=c(0,2000),ylim=c(0,2000))


##Figure 3c
theta<-c(alpha.gamma,beta.gamma)
QQ_gamma(x,theta,xlim=c(0,2000),ylim=c(0,2000))


